//$**************************************************************
//$					Copyright (C) 2011 by L-1 Identity Solutions
//$  Name:        $Workfile: CaptureDlg.h $
//$  Author:      $Author: Jmacdonald $
//$
//$  Description:	TPAPI Sample Application capture dialog
//$
// 
#pragma once

#ifdef USE_FSW
#include "USBHIDIO\USBHIDIO.h"
#endif

#define WM_USER_INIT              (WM_USER + 1)
#define WM_USER_DSPLY             (WM_USER + 2)
#define WM_USER_PREVIEW           (WM_USER + 3)

#define NUM_FNGRS                21

// SetupBitmap palette mode bits
#define UNDECORATED              0
#define DECORATED_RTQA           1
#define DECORATED_HANDSPEED      2

typedef enum
{
    FNGR_LFOUR = 1,
    FNGR_LTHUMB,
    FNGR_LINDEX,
    FNGR_LMIDDLE,
    FNGR_LRING,
    FNGR_LLITTLE,

    FNGR_RFOUR,
    FNGR_RTHUMB,
    FNGR_RINDEX,
    FNGR_RMIDDLE,
    FNGR_RRING,
    FNGR_RLITTLE,

    FNGR_LHAND,
    FNGR_LWRITERS,
    FNGR_LPALM,
    FNGR_RHAND,
    FNGR_RWRITERS,
    FNGR_RPALM,

    FNGR_THUMBS
} eFingerType;          

struct s_ctypeInfo {
   enum eCaptureType    base_ctype;
   int                  statusLED;
};

class CImageWnd : public CWnd
{
protected:
	afx_msg void OnPaint();

	DECLARE_MESSAGE_MAP()
};

// CCaptureDlg dialog
class CCaptureDlg : public CDialog
{
public:
	CCaptureDlg(unsigned int,enum eFingerType,enum eCaptureType,
		unsigned long,unsigned int,CWnd* pParent = NULL);
	virtual ~CCaptureDlg();
   void EnableGUI(bool);
	void UpdateDisplay(int,bool postMsg = true);
	long EvaluateRTQAInfo(void);
	long SetPreview(void);
	long CallbkCaptured(LPBYTE,unsigned short,unsigned short);
	long SetUIProgress(enum eCaptureType, enum eLEDState, BOOL);
   bool CancelQrySwitches(void);

	enum { IDD = IDD_CAPTURE };
	CImageWnd         wImage;
	CFont             m_stateFont;
	CFont             m_fngrFont;
	CFont             m_Font;
	CBrush            m_brush;
	COLORREF          m_crColor;
	unsigned int      XSize, YSize;
	unsigned char    *bitmapData;
	CBitmap				m_bmImage;
	unsigned char    *m_pImageBuf;
   unsigned int      m_hDev;
	long              m_captureMode;
	unsigned int      m_captureState;
	unsigned int      m_RTQAThrhld;
	enum eCaptureType m_capType;
	bool              m_queryingSwitches;
   bool              m_bCapturing;
   CDC               dcMemImage;
#ifdef DISPLAY_FPS
   DWORD             startTime, curTime;
   int               numFrms;
   CStatic          *m_lblFPS;
#endif

protected:
	virtual BOOL OnInitDialog();
   void OnCancel();
   void OnClose();
   void OnDestroy();
	afx_msg void OnBnClickedAbort();
	afx_msg void OnBnClickedScan();
	afx_msg void OnBnClickedSave();
	afx_msg HBRUSH OnCtlColor(CDC*, CWnd*, UINT);
	afx_msg LRESULT OnUpdateDisplay(WPARAM,LPARAM);
	afx_msg LRESULT OnStartPreview(WPARAM,LPARAM);
   afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
   afx_msg void OnTimer(UINT_PTR nIDEvent);

#ifdef USE_FSW
   CUSBHIDIO      m_FootSw;
#endif
	struct s_capDsp {
		char        stateTxt[12];
		char        fngrTxt[32];
		CBitmap		fngrImg;
		int   		fngrImgRes;
		CBitmap		operState;
		int   		operStateRes;
		char        operTxt[64];
		CBitmap		btns;
		int   		btnsRes;
	}					capDsp;
	CBitmap			m_bmpAbort;
	CBitmap			m_bmpScan;
	CBitmap			m_bmpReScan;
	CBitmap			m_bmpSave;
	eFingerType		m_Finger;

   CStatic		  *m_ctlState;
	CStatic		  *m_ctlFngrImg;
	CStatic		  *m_ctlFngrTxt;
	CStatic		  *m_ctlOperState;
	CStatic		  *m_ctlOperTxt;
	CStatic		  *m_ctlBtns;
   HCURSOR        m_hCur;

	DECLARE_MESSAGE_MAP()
};
